# Next.js 博客系统

这是一个基于 Next.js、TypeScript 和 Markdown 构建的静态博客系统。本项目在 Next.js 官方的 blog-starter 基础上进行了优化和改进，增加了 TypeScript 支持，为开发者提供更好的类型检查和开发体验。

## 主要特点

- 使用 Next.js 的静态生成功能，实现快速加载和优秀的 SEO 表现
- 支持 Markdown 格式的博客内容，方便编写和管理
- 集成 TypeScript，提供更好的开发体验
- 使用 Tailwind CSS 构建响应式界面
- 支持文章元数据管理（标题、作者、日期等）

## 在线演示

访问 [https://blog-starter.botbio.site](https://blog-starter.botbio.site) 查看在线演示。

## 快速开始

1. 项目并安装依赖：

```bash
npm install
```

2. 启动开发服务器：

```bash
npm run dev
```

## 创建新文章

在 `/_posts` 目录下创建新的 Markdown 文件即可创建新的博客文章。

## 文章格式

```markdown
---
title: "窗外的田园牧歌"
excerpt: "在日式房间里，透过宽大的落地窗，远眺绿意盎然的田园风光，感受大自然的宁静与美好。这不仅仅是一次旅行，更是一场心灵的洗涤。"
coverImage: "/assets/blog/countryside-view/cover.png"
date: "2025-03-21T05:35:07.322Z"
author:
  name: 佳琪
  picture: "/assets/blog/authors/avatar_01.png"
ogImage:
  url: "/assets/blog/countryside-view/cover.png"
---

推开日式房间的拉门，映入眼帘的是一幅绝美的田园画卷。阳光洒在榻榻米上，温暖而舒适。透过宽大的落地窗，远处的山峦连绵起伏，近处的田野绿意盎然，构成了一幅宁静而祥和的画面。空气中弥漫着泥土的芬芳和青草的清香，深吸一口气，仿佛所有的烦恼都烟消云散。

在这里，时间仿佛静止了。你可以静静地坐在窗边，品一杯清茶，感受微风拂过脸庞的温柔。远处传来鸟儿的鸣叫声，与风声、水声交织在一起，构成了一首动听的自然交响曲。目光所及之处，皆是令人心旷神怡的景色。稻田在微风中摇曳，泛起层层绿浪；远处的树木郁郁葱葱，如同绿色的屏障，守护着这片宁静的土地。

## 沉浸于自然

这次旅行，我远离了城市的喧嚣，来到了这片宁静的田园。在这里，我感受到了大自然的魅力，也找到了内心的平静。无论是清晨的薄雾，还是傍晚的夕阳，都让我沉醉其中。清晨，薄雾笼罩着田野，如同给大地披上了一层轻纱，朦胧而神秘。阳光透过薄雾，洒下点点金光，照亮了田野的每一个角落。傍晚，夕阳西下，天空被染成了绚丽的色彩，红色、橙色、黄色交织在一起，美不胜收。

这不仅仅是一次旅行，更是一场心灵的洗涤，让我重新认识了生活的美好。我开始更加珍惜身边的每一份美好，也更加热爱这片孕育生命的土地。我相信，即使回到喧嚣的城市，这份宁静与美好也会一直陪伴着我，给予我力量和勇气。
```
