# OOTD Mini Program 后端服务

这是穿搭小程序的后端服务器，提供天气API和OOTD生成功能。

## 安装

克隆仓库后，进入server目录安装依赖：

```bash
cd server
npm install
```

## 配置

确保根目录下有`.env`文件，包含以下环境变量：

```
COZE_TOKEN=你的Coze_API_Token
PORT=3000  # 可选，默认为3000
```

## 运行

开发模式运行（使用nodemon自动重启）：

```bash
npm run dev
```

生产模式运行：

```bash
npm start
```

## API接口

### 1. 获取天气数据

**请求：**

```
GET /api/weather?city=北京
```

| 参数 | 类型 | 描述 |
|------|------|------|
| city | string | 城市名称 |

**响应：**

```json
{
  "success": true,
  "data": [
    {
      "condition": "晴",
      "humidity": 46,
      "predict_date": "2025-03-09",
      "temp_high": 17,
      "temp_low": 4,
      "weather_day": "晴",
      "wind_dir_day": "西南风",
      "wind_dir_night": "西南风",
      "wind_level_day": "3",
      "wind_level_night": "3"
    },
    // ... 其他6天的天气数据
  ]
}
```

### 2. 生成OOTD穿搭建议

**请求：**

```
POST /api/generate-ootd
```

请求体：

```json
{
  "city": "北京",
  "gender": "男",
  "personalTrait": "男生，戴眼镜",
  "selectedStyle": "日系",
  "weather": {
    "condition": "多云",
    "humidity": 32,
    "predict_date": "2025-03-15",
    "temp_high": 10,
    "temp_low": 0,
    "weather_day": "多云",
    "wind_dir_day": "西北风",
    "wind_dir_night": "西北风",
    "wind_level_day": "3",
    "wind_level_night": "2"
  }
}
```

**响应：**

```json
{
  "success": true,
  "data": {
    "advice": "北京今日多云，温差较大(0 - 10℃)。日系风格的话，可以内搭白色高领毛衣，保暖又清爽，外面穿一件深灰色的长款风衣，下身搭配黑色直筒裤。鞋子选择棕色的皮鞋，增加整体的精致感。配饰上可以搭配一条浅棕色的围巾，与鞋子颜色相呼应。整体造型给人一种简约、文艺的感觉，很符合日系穿搭的风格。",
    "images": [
      "https://s.coze.cn/t/783dOwLtccc/",
      "https://s.coze.cn/t/Xp4MotYzy_4/",
      "https://s.coze.cn/t/e9lsZI6zHVs/"
    ]
  }
}
``` 