Component({
  data: {
    movieName: "",
    messages: [],
    inputValue: "",
    scrollToMessage: "",
    isLoading: false,
    conversationId: "",
    chatId: "",
  },

  methods: {
    onLoad(options: any) {
      const movieName = decodeURIComponent(options.movieName || "");
      this.setData({ movieName });

      if (movieName) {
        this.addMessage("user", movieName);
        this.requestChatAPI(movieName);
      }
    },

    addMessage(type: "user" | "assistant", content: string) {
      const messages = [...this.data.messages, { type, content }];
      this.setData({
        messages,
        scrollToMessage: `msg-${messages.length - 1}`,
      });
      return messages;
    },

    async requestChatAPI(message: string) {
      this.setData({ isLoading: true });
      let fullResponse = "";

      this.addMessage("assistant", "");

      try {
        const requestTask = wx.request({
          url: "http://localhost:3001/api/chat",
          method: "POST",
          data: {
            message: message,
            conversationId: this.data.conversationId,
          },
          enableChunked: true,
          success: () => {
            console.log("Request completed successfully");
          },
          fail: (error) => {
            console.error("Request failed:", error);
            wx.showToast({
              title: "请求失败",
              icon: "error",
            });
            this.setData({ isLoading: false });
          },
        });

        requestTask.onChunkReceived((response) => {
          try {
            const chunk = new TextDecoder().decode(response.data);
            const lines = chunk.split("\n");

            for (const line of lines) {
              if (line.startsWith("data: ")) {
                const data = line.slice(6);
                if (data === "[DONE]") {
                  this.setData({ isLoading: false });
                  return;
                }

                try {
                  const parsedData = JSON.parse(data);


                  if (parsedData.type === "content" && parsedData.content) {
                    fullResponse += parsedData.content;

                    const updatedMessages = [...this.data.messages];
                    updatedMessages[updatedMessages.length - 1].content =
                      fullResponse;

                    this.setData({
                      messages: updatedMessages,
                      scrollToMessage: `msg-${updatedMessages.length - 1}`,
                      conversationId: parsedData.conversationId,
                      chatId: parsedData.chatId,
                    });
                  }
                } catch (e) {
                  this.setData({ isLoading: false });
                  console.error("Error parsing chunk data:", e);
                }
              }
            }
          } catch (e) {
            console.error("Error processing chunk:", e);
          }
        });
      } catch (error) {
        console.error("Error:", error);
        wx.showToast({
          title: "请求失败",
          icon: "error",
        });
        this.setData({ isLoading: false });
      }
    },

    onInput(e: any) {
      this.setData({
        inputValue: e.detail.value,
      });
    },

    sendMessage() {
      if (this.data.isLoading) {
        wx.showToast({
          title: "请等待当前回复完成",
          icon: "none",
        });
        return;
      }

      const message = this.data.inputValue.trim();
      if (!message) return;

      this.addMessage("user", message);
      this.setData({ inputValue: "" });

      this.requestChatAPI(message);
    },
  },
});
