const express = require("express");
const {
  CozeAPI,
  ChatEventType,
  RoleType,
  COZE_CN_BASE_URL,
} = require("@coze/api");

require("dotenv").config();

const app = express();
const port = 3001;

// 初始化 Coze API 客户端
const client = new CozeAPI({
  baseURL: COZE_CN_BASE_URL,
  token: process.env.COZE_API_TOKEN,
});

app.use(express.json());

// 创建聊天接口
app.post("/api/chat", async (req, res) => {
  const { message, conversationId } = req.body;

  try {
    // 设置响应头
    res.setHeader("Content-Type", "text/event-stream");
    res.setHeader("Cache-Control", "no-cache");
    res.setHeader("Connection", "keep-alive");
    res.setHeader("Access-Control-Allow-Origin", "*"); // 允许跨域
    res.setHeader("X-Content-Type-Options", "nosniff"); // 防止内容类型嗅探

    // 调用 Coze API
    const stream = await client.chat.stream({
      bot_id: process.env.BOT_ID,
      conversation_id: conversationId,
      additional_messages: [
        {
          role: RoleType.User,
          content: message,
          content_type: "text",
        },
      ],
      auto_save_history: true, // 启用历史记录保存
    });

    // 流式输出响应
    for await (const part of stream) {
      if (part.event === ChatEventType.CONVERSATION_MESSAGE_DELTA) {
        res.write(
          `data: ${JSON.stringify({ 
            type: 'content',
            content: part.data.content ,
            conversationId: part.data.conversation_id,
            chatId: part.data.id,
          })}\n\n`
        );
      }
    }

    res.write("data: [DONE]\n\n");
    res.end();
  } catch (error) {
    console.error("Error:", error);
    res.status(500).json({ error: "Internal Server Error" });
  }
});

app.listen(port, () => {
  console.log(`Server running on port ${port}`);
});
