# 产品需求文档：AI初创项目评估工具

## 1. 项目概述
- **产品定位**：帮助投资人或分析师快速从初创公司落地页文案中生成中文评估报告，涵盖核心信息提炼、投资价值判断与风险提示。
- **价值主张**：通过复制落地页文本即可输出结构化分析，提升筛选效率并降低漏判优质项目的概率。
- **项目阶段**：0→1 原型设计与验证。

## 2. 目标用户与使用场景
- **主要用户**：风险投资机构投资经理、产业投资人、企业创新部门负责人。
- **使用场景**：初筛项目、路演前调研、行业扫描时快速判断项目价值。
- **用户目标**：在 3 分钟内获得可读性高、结构化的项目评估报告，并形成初步投资判断。

## 3. 业务目标与成功指标
- **初期 KPI**：
  - >=80% 的分析请求在 60 秒内返回初稿。
  - >=70% 的用户认为报告结构与投资评估所需信息匹配（后续通过问卷验证）。
  - 日均有效分析请求 >=30 次（试运营阶段）。
- **长期 North Star 指标**：经评估后的项目进入深入尽调或投资讨论的转化率。

## 4. 产品范围
- **In Scope**：
  - 单页文本输入与 AI 报告生成。
  - 抽屉式结果展示与加载骨架图。
  - 风险投资视角的评分、要点提炼与市场评估。
- **Out of Scope（迭代考虑）**：
  - 自动抓取网页内容、附件解析、财务模型生成。
  - 多语言输出与多用户协同评论。

## 5. 用户旅程概览
1. 用户访问首页，阅读标题指引。
2. 将初创公司落地页全部文本复制到文本框（默认高度 5 行，可自动扩展）。
3. 点击「开始分析」。
4. 顶部抽屉覆盖 95% 屏幕高度，展示加载骨架图。
5. AI 生成报告后在抽屉内渲染，包括综合评分与详细分析。
6. 用户可复制报告或关闭抽屉返回首页。

## 6. 功能需求
- **FR1 文本输入**
  - 支持粘贴多段文本，保留换行与基本格式。
  - 限制最大字符数（默认 8000 字符），超限提示剩余可用量。
- **FR2 分析触发**
  - 点击按钮后禁用按钮并显示加载状态，防止重复请求。
  - 将用户输入以结构化 Prompt 发送至后端 AI 服务。
- **FR3 AI 报告生成**
  - 输出结构包括综合评分、评分理由、名称、核心功能、产品卖点、应用领域、市场评估、风险提示、下一步建议。
  - 输出语言默认中文，关键字段以标题+正文形式呈现。
- **FR4 抽屉展示**
  - 抽屉自顶部滑出，高度 95% 屏幕，可滚动。
  - 加载阶段展示骨架图（标题条、评分块、列表块等），直至结果返回。
- **FR5 错误处理**
  - 网络或 AI 错误时在抽屉内展示错误状态与重试按钮。
- **FR6 报告导出（迭代候选）**
  - 预留复制全文按钮接口。

### 验收标准
- 输入框粘贴 5000 字后仍保持响应，按钮禁用状态正确。
- 在正常网络下，用户点击后 1 秒内抽屉出现并显示骨架图。
- 报告包含所有必需字段且为中文表述。
- 错误场景可复现并提示清晰。

## 7. AI 交互与提示设计
- **Prompt 模板核心要素**：
  - 输入部分：原始落地页文本。
  - 指令部分：要求提炼指定字段、给出 0-100 评分及理由、输出中文。
- **评分规则建议**：
  - 维度：市场空间、产品竞争力、团队信号、商业模式、增长潜力。
  - 评分公式：`综合评分 = Σ(维度分 * 权重)`，初始权重平均分布，后续可基于反馈调整。
- **校验策略**：
  - 若检测到输入为空或含大量无意义字符（>50% 非中文/英文），直接返回错误。

## 8. 报告结构与示例（以 Cursor AI IDE 为例）
- **报告结构**：
  1. 评分卡片：`风险投资视角综合评分：X/100` + 50 字内理由。
  2. 关键要点：名称、核心功能、产品卖点、应用领域、市场评估、风险与关注点、后续建议。
  3. 附加洞察（可选）：竞争格局、可验证指标建议。
- **示例输出**：

```startLine:endLine:prd.md
风险投资视角综合评分：85/100
主要理由：团队背景公开透明，产品针对 AI 编程痛点，具备明确付费转化场景，但社区规模与差异化护城河仍需验证。

名称：Cursor（AI 原生集成开发环境）
核心功能：在 IDE 内提供代码自动补全、自然语言到代码生成、调试建议与多轮对话辅助。
产品卖点：无缝嵌入 VS Code 类体验、上下文记忆优化长代码库、多人协作共享会话。
应用领域：AI 辅助软件开发、内部工具研发效率提升、生成式 AI 应用创业团队。
市场评估：生成式 AI 开发市场高速增长，北美与全球开发者对智能 IDE 支付意愿提升；竞争对手（GitHub Copilot、Replit AI）强势，需要持续差异化功能与生态绑定。
风险与关注点：依赖外部大模型在成本与性能上的不确定性；需遵循企业代码隐私合规；扩张到企业级客户需要完善的权限与部署方案。
后续建议：增加与主流代码托管平台的深度集成；构建更多行业案例以证明效率提升 ROI；探索自研或多模型路由降低推理成本。
```

## 9. UI/UX 要求
- 首页主体为标题、副文案、主输入框、操作按钮。
- 文本框默认显示 5 行，支持拖拽或自动增高至最多 20 行。
- 按钮状态：默认、悬停、禁用、加载。
- 抽屉顶部保留关闭控件；内部采用分段标题样式，评分卡片使用突出样式。
- 骨架图模版：评分卡骨架（矩形）、标题骨架、3-4 行文本骨架。

## 10. 技术与集成要求
- 前端框架：继承现有 Next.js/React 技术栈。
- AI 服务：使用已有 LLM API（可为 OpenAI、Anthropic 等），需支持中文输出与温度调节。
- API 交互：POST `/api/analyze`，请求体包含 `rawContent`，返回 JSON。错误码需覆盖超时、配额不足等情况。
- 日志：记录请求耗时、字数、失败原因，脱敏存储。

## 11. 性能与安全要求
- 单次请求建议超时阈值 45 秒，前端超时提示。
- 所有分析文本仅做瞬时处理，不写入长期存储；若需缓存，必须经过加密与访问控制。
- 防止注入类 Prompt 攻击，必要时对用户输入做关键词过滤。

## 12. 分析与监控
- 采集指标：请求量、成功率、平均响应时长、评分分布。
- A/B 选项：不同 Prompt 权重或报告结构。
- 错误监控接入 Sentry/Logtail，异常超过阈值触发告警。

## 13. 风险与依赖
- 对第三方 LLM 服务的稳定性与成本依赖高。
- 初始评分体系可能失真，需要人工校准与持续学习。
- 大文本输入可能引发 token 成本与超长响应时间问题，需要提示用户裁剪非关键信息。

## 14. 里程碑建议
- 第 1 周：完成低保真原型、Prompt 设计试验。
- 第 2 周：实现前端页面与抽屉交互、接入 AI API。
- 第 3 周：完成错误处理、样式细化、埋点。
- 第 4 周：试运行收集反馈，优化评分模型与报告结构。


