"use client"

import { AnalysisReport } from "@/lib/mock-data"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Button } from "@/components/ui/button"
import { Copy, Check } from "lucide-react"
import { useState } from "react"

interface ReportDisplayProps {
  report: AnalysisReport
}

export function ReportDisplay({ report }: ReportDisplayProps) {
  const [copied, setCopied] = useState(false)

  const handleCopy = async () => {
    const reportText = `风险投资视角综合评分：${report.score}/100
${report.scoreReason}

名称：${report.name}
核心功能：${report.coreFunction}
产品卖点：${report.productSellingPoint}
应用领域：${report.applicationField}
市场评估：${report.marketAssessment}
风险与关注点：${report.risksAndConcerns}
后续建议：${report.nextSteps}`

    await navigator.clipboard.writeText(reportText)
    setCopied(true)
    setTimeout(() => setCopied(false), 2000)
  }

  return (
    <div className="space-y-6">
      <div className="flex items-center justify-between">
        <h2 className="text-2xl font-semibold">分析报告</h2>
        <Button
          variant="outline"
          size="sm"
          onClick={handleCopy}
          className="gap-2"
        >
          {copied ? (
            <>
              <Check className="h-4 w-4" />
              已复制
            </>
          ) : (
            <>
              <Copy className="h-4 w-4" />
              复制报告
            </>
          )}
        </Button>
      </div>

      <Card>
        <CardHeader>
          <CardTitle className="text-xl">
            风险投资视角综合评分：{report.score}/100
          </CardTitle>
        </CardHeader>
        <CardContent>
          <p className="text-muted-foreground">{report.scoreReason}</p>
        </CardContent>
      </Card>

      <div className="space-y-4">
        <div>
          <h3 className="text-lg font-semibold mb-2">名称</h3>
          <p className="text-muted-foreground">{report.name}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">核心功能</h3>
          <p className="text-muted-foreground">{report.coreFunction}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">产品卖点</h3>
          <p className="text-muted-foreground">{report.productSellingPoint}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">应用领域</h3>
          <p className="text-muted-foreground">{report.applicationField}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">市场评估</h3>
          <p className="text-muted-foreground">{report.marketAssessment}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">风险与关注点</h3>
          <p className="text-muted-foreground">{report.risksAndConcerns}</p>
        </div>

        <div>
          <h3 className="text-lg font-semibold mb-2">后续建议</h3>
          <p className="text-muted-foreground">{report.nextSteps}</p>
        </div>
      </div>
    </div>
  )
}

