This is a [Next.js](https://nextjs.org) project bootstrapped with [`create-next-app`](https://nextjs.org/docs/app/api-reference/cli/create-next-app).

## 环境配置

在项目根目录创建 `.env.local` 文件，并配置 DashScope API Key：

```bash
DASHSCOPE_API_KEY=sk-xxx
```

获取 API Key：
1. 访问 [DashScope 控制台](https://dashscope.console.aliyun.com/)
2. 创建 API Key
3. 将 API Key 复制到 `.env.local` 文件中

## Getting Started

首先安装依赖：

```bash
pnpm install
```

然后运行开发服务器：

```bash
pnpm dev
```

打开 [http://localhost:3000](http://localhost:3000) 查看应用。

## 功能说明

这是一个 AI 初创项目评估工具，可以：

1. **输入落地页文案**：将初创公司落地页的全部文本复制到输入框（最多 8000 字符）
2. **生成分析报告**：AI 会自动分析文案并生成结构化报告，包括：
   - 风险投资视角综合评分（0-100 分）
   - 产品/公司名称
   - 核心功能
   - 产品卖点
   - 应用领域
   - 市场评估
   - 风险与关注点
   - 后续建议

## API 端点

### POST /api/report

分析落地页文案并返回结构化报告。

**请求体：**
```json
{
  "text": "落地页文案内容..."
}
```

**响应：**
```json
{
  "score": 85,
  "scoreReason": "评分理由",
  "name": "产品名称",
  "coreFunction": "核心功能",
  "productSellingPoint": "产品卖点",
  "applicationField": "应用领域",
  "marketAssessment": "市场评估",
  "risksAndConcerns": "风险与关注点",
  "nextSteps": "后续建议"
}
```

## Learn More

To learn more about Next.js, take a look at the following resources:

- [Next.js Documentation](https://nextjs.org/docs) - learn about Next.js features and API.
- [Learn Next.js](https://nextjs.org/learn) - an interactive Next.js tutorial.

You can check out [the Next.js GitHub repository](https://github.com/vercel/next.js) - your feedback and contributions are welcome!

## Deploy on Vercel

The easiest way to deploy your Next.js app is to use the [Vercel Platform](https://vercel.com/new?utm_medium=default-template&filter=next.js&utm_source=create-next-app&utm_campaign=create-next-app-readme) from the creators of Next.js.

Check out our [Next.js deployment documentation](https://nextjs.org/docs/app/building-your-application/deploying) for more details.

**注意**：部署到 Vercel 时，需要在项目设置中添加 `DASHSCOPE_API_KEY` 环境变量。
