# H5 英语单词学习 - 产品需求文档（PRD）

版本：v0.1  
更新时间：2025-09-08  
状态：草案

## 1. 背景与目标
- 背景：面向移动端（H5）的英语单词学习工具，提供入门级的“选词书→逐词学习→查看进度”闭环。依托现有 Next.js + NextAuth + Postgres 基础设施快速实现 MVP。
- 目标：
  - 用户可浏览词书并进行学习。
  - 登录后记录学习进度，支持断点续学与“最近学习”。
  - 以简单的单词卡片进行快速学习，点击进入详情可查看更多信息。

## 2. 角色与用户故事
- 访客：
  - 我希望在首页看到所有单词书，点击后提示我登录/注册。
- 已登录用户：
  - 我希望首页能看到“最近学习”，一键继续学习。
  - 我希望在“我的”里看到邮箱、学习进度，并可退出登录。
  - 我希望进入词书后，从上次学过的下一个单词自动开始。

## 3. 信息架构与路由
- `"/"`：首页（Home）
- `"/me"`：我的（Profile/Account）
  - `"/me?auth=login" | "/me?auth=register"`：在“我的”页面以弹窗形式展示登录/注册。
- `"/learn/[bookId]"`：学习页（单词卡片流）
- `"/word/[bookId]/[idx]"`：单词详情页（由学习页或首页跳转）

全局导航：底部 2 个 Tab（首页、我的），在所有主页面固定展示。

## 4. 页面与交互（含线框图）

说明：线框图为示意，主要表达布局与信息层级。移动端默认宽度按 375px 参考。

### 4.1 全局 - 底部 Tab
```
+---------------------------------------------------+
|                   主内容区域                       |
|                                                   |
|                                                   |
|                                                   |
+---------------------------------------------------+
| [ 首页 ]                             [  我的  ]   |
+---------------------------------------------------+
```
- 首页：默认选中首页；点击“我的”进入“我的”页面。

### 4.2 首页（未登录）
需求：仅展示所有单词书；点击任意词书→跳转“我的”并打开登录弹窗。
```
+------------------ 首页（未登录） ------------------+
|  标题：单词书                                        |
|  [ 词书卡片 A ]  [ 词书卡片 B ]  [ 词书卡片 C ]      |
|  （卡片内：词书标题、单词数量、可选预览若干词）       |
|                                                     |
|  ...                                                |
+-----------------------------------------------------+
| [ 首页(选中) ]                      [  我的  ]       |
+-----------------------------------------------------+
```
- 行为：点击任一词书卡片→导航至 `"/me?auth=login"`。

### 4.3 首页（已登录）
需求：顶部展示“最近学习”（若无数据则不展示），其下展示所有单词书。
```
+------------------ 首页（已登录） ------------------+
| 最近学习                                            |
|  [ 继续学习：词书A ]   [ 继续学习：词书B ]           |
|  （按最近更新时间排序，最多展示 3 个，可横向滑动）    |
|                                                     |
| 单词书                                              |
|  [ 词书卡片 A ]  [ 词书卡片 B ]  [ 词书卡片 C ]      |
|                                                     |
+-----------------------------------------------------+
| [ 首页(选中) ]                      [  我的  ]       |
+-----------------------------------------------------+
```
- 行为：点击“继续学习”→进入对应 `"/learn/[bookId]"`，从最近学习的下一个单词开始。

### 4.4 我的（Profile）
需求：显示用户邮箱、退出登录、学习进度汇总。
```
+----------------------- 我的 -----------------------+
| 头像(占位)   邮箱：user@example.com                 |
|                                                     |
| 学习进度                                            |
|  词书A：45/100（45%）   上次学习：2025-09-01         |
|  词书B：10/80（12%）    上次学习：2025-09-05         |
|                                                     |
| [ 退出登录 ]                                        |
+-----------------------------------------------------+
| [ 首页 ]                              [ 我的(选中) ]|
+-----------------------------------------------------+
```
- 未登录状态：进入“我的”时默认弹出登录弹窗；弹窗可切换“登录/注册”。
- 参考已有逻辑：
  - 登录：`app/login/page.tsx` 的 `signIn('credentials', ...)` Server Action。
  - 注册：`app/register/page.tsx` 的 `createUser` Server Action（成功后刷新并关闭弹窗）。

### 4.5 学习页（单词卡片流）
需求：从“最近学习的单词的下一个”开始。卡片尽量简洁，点击“下一个”切换。点击单词跳转详情。
```
+------------------- 学习：词书A ---------------------+
|  顶部：进度 46/100     返回                         |
|                                                     |
|  [   r u l e r   ]   /ˈruːlə/  /ˈruːlər/            |
|  简短释义：尺子                                      |
|  示例：a 12-inch ruler                               |
|                                                     |
|          [  下一条  ▶ ]                             |
+-----------------------------------------------------+
| [ 首页 ]                              [ 我的 ]      |
+-----------------------------------------------------+
```
- 行为：
  - 点击单词/卡片正文→跳转 `"/word/[bookId]/[idx]"`。
  - 点击“下一条”→保存进度（lastIdx += 1），拉取下一词并渲染。
  - 进度到达末尾提示“已完成词书”。

### 4.6 单词详情页
需求：展示更丰富的信息：音标、英/中释义、同近、例句、记忆法等。
```
+------------------- 详情：ruler ---------------------+
|  返回                                               |
|  单词：ruler    英 /ˈruːlə/   美 /ˈruːlər/          |
|  中文释义：尺子                                     |
|  英文释义：a long flat...                           |
|  同近：governor, dominator ...                      |
|  例句：a 12-inch ruler                              |
|  记忆：没有规矩(rule)...                            |
|                                                     |
|  [ 继续学习 ]                                       |
+-----------------------------------------------------+
```
- 行为：
  - “继续学习”返回学习流，停留在当前或下一条。

## 5. 数据结构与字段映射

### 5.1 词书与单词（数据来源示例）
示例 JSON（单条）：
```
{
  "idx": 0,
  "id": 1,
  "wordRank": 1,
  "headWord": "ruler",
  "content": "{\"word\": { ... 包含释义/音标/例句/同近/记忆 等 }}",
  "bookId": "PEPXiaoXue3_1"
}
```
建议：
- 词书（Book）：
  - `bookId: string`（如示例中的 PEPXiaoXue3_1）
  - `title: string`（可映射为“PEP 小学 三年级 上 册”等，MVP 可与 bookId 同名）
  - `count: number`（单词数）
- 单词（Word）：
  - `idx: number`（词书内索引，用于学习顺序）
  - `headWord: string`（主显示）
  - `phoneticUk: string` ← `content.word.content.ukphone`
  - `phoneticUs: string` ← `content.word.content.usphone`
  - `transCn: string` ← `content.word.content.trans[0].tranCn`
  - `transEn: string` ← `content.word.content.trans[0].tranOther`（可选）
  - `exampleEn: string` ← `content.word.content.sentence.sentences[0].sContent`（可选）
  - `exampleCn: string` ← `content.word.content.sentence.sentences[0].sCn`（可选）
  - `synonyms: string[]` ← `content.word.content.syno.synos[].hwds[].w`（可选）
  - `memo: string` ← `content.word.content.remMethod.val`（可选）

卡片渲染（学习页）建议最小字段：`headWord`、`phoneticUk/Us`、`transCn`、`exampleEn`。
详情页再补充 `transEn`、`synonyms`、`memo` 等。

### 5.2 进度数据（Postgres）
新建表：`Progress`
- `id` SERIAL PK
- `userId` INTEGER NOT NULL → 关联 `User.id`
- `bookId` TEXT NOT NULL
- `lastIdx` INTEGER NOT NULL DEFAULT -1  （-1 表示未开始，进入学习从 0 开始）
- `updatedAt` TIMESTAMP NOT NULL DEFAULT NOW()

约束：`UNIQUE(userId, bookId)`

规则：
- 进入 `"/learn/[bookId]"` 时：
  - 若无记录→创建 `{ lastIdx: -1 }` 并从 `nextIdx = 0` 开始。
  - 若有记录→从 `nextIdx = lastIdx + 1` 开始；若超出末尾→提示完成。
- 点击“下一条”时：
  - 更新 `lastIdx = currentIdx` 并刷新 `updatedAt`。
- 首页“最近学习”依据 `updatedAt` 倒序展示（最多 3 个）。

## 6. 交互与状态管理
- 技术：Next.js App Router + React Server Components + Server Actions。
- 数据获取：
  - 词书/单词：读取静态 JSON 文件（`/data/books/index.json`、`/data/books/[bookId].json`）或从 DB/对象存储中读取（MVP 建议静态文件）。
  - 进度：Server Action 读写 `Progress` 表。
- 鉴权：NextAuth（现有 `credentials`），`middleware.ts` 已保护 `/protected` 等路径；本项目需开放 `/`、`/me`、`/learn/*`、`/word/*`，但在未登录时对“学习进度保存”写操作做保护。

## 7. 登录弹窗（复用现有逻辑）
- 打开时机：
  - 未登录用户在首页点击任意词书→路由跳转 `"/me?auth=login"`。
  - “我的”页未登录→默认打开。
- 弹窗内容：
  - Tab：登录 | 注册
  - 登录：复用 `app/login/page.tsx` 里的 `signIn('credentials', ...)` Server Action。
  - 注册：复用 `app/register/page.tsx` 的 `createUser` Server Action（成功后刷新并关闭弹窗）。
- 关闭：点击遮罩或关闭按钮。

## 8. 空态与异常
- 最近学习空态：不展示该模块。
- 词书列表空态：展示占位说明“暂无词书”。
- 学习到末尾：提示“已完成该词书”，提供返回首页或重新学习入口。
- JSON 解析失败：回退仅展示 `headWord`，并提示“内容暂不可用”。
- 网络/服务异常：toast 提示并可重试。

## 9. 指标与埋点（可选）
- 登录转化：弹窗展示→提交→成功率。
- 学习留存：每日学习单词量、连续学习天数。
- 词书完成率：完成词书人数/比率。

## 10. 非功能性
- 性能：
  - 词书 JSON 分页/按需加载（学习页逐条加载）。
  - 图片/音频（如后续加入 TTS）懒加载。
- 适配：移动优先（375–428px），同时确保桌面可用。
- 可访问性：按钮可聚焦，语义化标签；色彩对比达标。

## 11. 验收标准（关键用例）
- 未登录进入首页：仅看到词书；点击词书→跳转 `/me` 并弹出登录。
- 登录后返回首页：看到“最近学习”（若已产生进度），点击可直达学习页。
- 学习页：
  - 进入词书后起始单词为“上次学习的下一个”。
  - 点击“下一条”会推进一条并在 DB 中更新 `lastIdx`。
  - 点击单词正文可进入详情页。
- 我的页：显示邮箱、各词书进度、可退出登录。

## 12. 未来扩展
- 复习模式（间隔重复/错题本/收藏）。
- 搜索与筛选（按难度、主题、词频）。
- 听力发音（TTS）与发音打分。
- 多端适配（PWA/离线缓存）。

---

# 附：界面组件清单（MVP）
- 底部 TabBar：`HomeTab` / `MeTab`
- 词书卡片：`BookCard`（标题、数量、预览词）
- 最近学习条目：`RecentBookItem`（继续学习按钮）
- 学习卡片：`WordCard`（词、音标、简释、例句、下一条）
- 详情面板：`WordDetail`（释义、同近、例句、记忆）
- 登录弹窗：`AuthModal`（登录/注册 Tab，复用 Server Action）

# 附：数据文件建议结构（静态方案）
- `data/books/index.json`
  - `[ { "bookId": "PEPXiaoXue3_1", "title": "PEP 小学 三年级(上)", "count": 300 }, ... ]`
- `data/books/PEPXiaoXue3_1.json`
  - `[ { idx, id, headWord, wordRank, content, bookId }, ... ]`

# 附：接口/Server Action 草案
- 获取词书清单：RSC 读取 `data/books/index.json`
- 获取词书某 idx 的词：RSC/Action 读取 `data/books/[bookId].json`
- 获取“最近学习”：Action 查询 `Progress` by userId，按 `updatedAt` 倒序取 Top 3
- 更新进度：`updateProgress(userId, bookId, lastIdx)`

# 附：字段解析示例（基于示例 JSON）
- 词：`headWord`，备选 `content.word.wordHead`
- 英音：`content.word.content.ukphone`；美音：`...usphone`
- 中释：`content.word.content.trans[0].tranCn`
- 英释：`content.word.content.trans[0].tranOther`
- 例句英：`content.word.content.sentence.sentences[0].sContent`
- 例句中：`...sentences[0].sCn`
- 同近：`content.word.content.syno.synos[].hwds[].w`
- 记忆：`content.word.content.remMethod.val`

