import { auth } from '@/app/auth';
import ProfilePage from '@/app/components/ProfilePage';
import { getUser, listAllLearningByUser } from '@/app/db';
import type { Book } from '@/app/lib/mock-data';

export default async function MePage() {
  const session = await auth();

  let userProgress: Array<{ id: number; book: Book; lastIdx: number; updatedAt: Date }> = [];
  if (session?.user) {
    // Resolve user id
    let userId: number | null = null;
    const maybeId = (session.user as any)?.id;
    const email = (session.user as any)?.email as string | undefined;
    if (maybeId !== undefined) {
      const n = Number(maybeId);
      if (!Number.isNaN(n)) userId = n;
    }
    if (!userId && email) {
      const rows = await getUser(email);
      if (rows && rows.length > 0) userId = Number(rows[0].id);
    }

    if (userId) {
      const recs = await listAllLearningByUser(userId);
      userProgress = recs.map((r) => ({
        id: r.id,
        lastIdx: r.last_idx,
        updatedAt: new Date(r.updated_at as any),
        book: {
          id: r.b_id,
          bookId: r.book_id,
          title: r.title,
          wordCount: r.word_count,
          coverUrl: r.cover_url || undefined,
          tags: r.tags || undefined,
          createdAt: new Date(),
        },
      }));
    }
  }

  return <ProfilePage session={session} userProgress={userProgress} />;
}
