import './globals.css';

import { GeistSans } from 'geist/font/sans';

let title = 'H5 英语单词学习';
let description =
  '面向移动端的英语单词学习工具，提供词书选择、逐词学习、进度追踪等功能';

export const metadata = {
  title,
  description,
  twitter: {
    card: 'summary_large_image',
    title,
    description,
  },
  metadataBase: new URL('https://nextjs-postgres-auth.vercel.app'),
};

export const viewport = {
  width: 'device-width',
  initialScale: 1,
  maximumScale: 1,
};

export default function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  return (
    <html lang="zh-CN">
      <body className={`${GeistSans.variable} min-h-screen bg-gray-50`}>{children}</body>
    </html>
  );
}
