"use client";
import Link from 'next/link';
import { HomeIcon, UserIcon } from '@heroicons/react/24/outline';
import { HomeIcon as HomeIconSolid, UserIcon as UserIconSolid } from '@heroicons/react/24/solid';

export default function TabBar({ active }: { active: 'home' | 'me' }) {
  const isHome = active === 'home';
  const isProfile = active === 'me';
  return (
    <div className="fixed bottom-0 left-0 right-0 bg-white border-t border-gray-200 z-50">
      <div className="flex h-16 max-w-screen-sm mx-auto">
        <Link
          href="/"
          className={`flex-1 flex flex-col items-center justify-center gap-1 transition-colors ${
            isHome ? 'text-blue-500' : 'text-gray-500'
          }`}
        >
          {isHome ? (
            <HomeIconSolid className="w-6 h-6" />
          ) : (
            <HomeIcon className="w-6 h-6" />
          )}
          <span className="text-xs">首页</span>
        </Link>
        
        <Link
          href="/me"
          className={`flex-1 flex flex-col items-center justify-center gap-1 transition-colors ${
            isProfile ? 'text-blue-500' : 'text-gray-500'
          }`}
        >
          {isProfile ? (
            <UserIconSolid className="w-6 h-6" />
          ) : (
            <UserIcon className="w-6 h-6" />
          )}
          <span className="text-xs">我的</span>
        </Link>
      </div>
    </div>
  );
}
