'use client';

import { useState } from 'react';
import { Book } from '@/app/lib/mock-data';
import { BookOpenIcon } from '@heroicons/react/24/outline';
import Image from 'next/image';

interface BookCardProps {
  book: Book;
  onClick: () => void;
}

export default function BookCard({ book, onClick }: BookCardProps) {
  const [imageError, setImageError] = useState(false);
  
  return (
    <div
      onClick={onClick}
      className="bg-white rounded-lg shadow-sm border border-gray-200 overflow-hidden cursor-pointer hover:shadow-md transition-shadow"
    >
      {/* Cover Image with 3:4 aspect ratio */}
      {book.coverUrl && !imageError ? (
        <div className="relative w-full" style={{ paddingBottom: '133.33%' }}>
          <Image
            src={book.coverUrl}
            alt={book.title}
            fill
            className="object-cover"
            sizes="(max-width: 640px) 50vw, (max-width: 768px) 33vw, 25vw"
            onError={() => setImageError(true)}
          />
          {/* Cover only; no progress overlay */}
        </div>
      ) : (
        <div className="relative w-full bg-gradient-to-br from-blue-100 to-indigo-100 flex items-center justify-center" style={{ paddingBottom: '133.33%' }}>
          <div className="absolute inset-0 flex items-center justify-center">
            <BookOpenIcon className="w-16 h-16 text-blue-300" />
          </div>
        </div>
      )}
      
      {/* Book Info */}
      <div className="p-4">
        <h3 className="font-semibold text-gray-900 text-sm mb-1 line-clamp-2">{book.title}</h3>
        <p className="text-xs text-gray-500 mb-2">{book.wordCount} 个单词</p>
        
        {book.tags && (
          <div className="flex flex-wrap gap-1">
            {book.tags.split(',').map((tag, index) => (
              <span
                key={index}
                className="px-2 py-0.5 bg-blue-50 text-blue-600 text-xs rounded"
              >
                {tag.trim()}
              </span>
            ))}
          </div>
        )}
      </div>
    </div>
  );
}
