import { NextAuthConfig } from 'next-auth';

export const authConfig = {
  pages: {
    signIn: '/login',
  },
  providers: [
    // added later in auth.ts since it requires bcrypt which is only compatible with Node.js
    // while this file is also used in non-Node.js environments
  ],
  callbacks: {
    authorized({ auth, request: { nextUrl } }) {
      let isLoggedIn = !!auth?.user;
      let isOnProtected = nextUrl.pathname.startsWith('/protected');
      let isOnLearn = nextUrl.pathname.startsWith('/learn');
      let isOnWord = nextUrl.pathname.startsWith('/word');

      // Only /protected, /learn, and /word routes require authentication
      if (isOnProtected || isOnLearn || isOnWord) {
        if (isLoggedIn) return true;
        return false; // Redirect unauthenticated users to login page
      }

      // Allow all other routes (including home page) for both logged in and logged out users
      return true;
    },
  },
} satisfies NextAuthConfig;
