import { NextResponse } from 'next/server';
import { auth } from '@/app/auth';
import { getUser, listRecentLearningByUser } from '@/app/db';

export const dynamic = 'force-dynamic';

export async function GET() {
  try {
    const session = await auth();
    if (!session?.user) return NextResponse.json({ ok: false, error: 'UNAUTHORIZED' }, { status: 401 });

    let userId: number | null = null;
    const maybeId = (session.user as any)?.id;
    const email = (session.user as any)?.email as string | undefined;
    if (maybeId !== undefined) {
      const n = Number(maybeId);
      if (!Number.isNaN(n)) userId = n;
    }
    if (!userId && email) {
      const rows = await getUser(email);
      if (rows && rows.length > 0) userId = Number(rows[0].id);
    }
    if (!userId) return NextResponse.json({ ok: false, error: 'UNAUTHORIZED' }, { status: 401 });

    const rec = await listRecentLearningByUser(userId, 3);
    const data = rec.map((r) => ({
      id: r.id,
      lastIdx: r.last_idx,
      updatedAt: r.updated_at,
      book: {
        id: r.b_id,
        bookId: r.book_id,
        title: r.title,
        wordCount: r.word_count,
        coverUrl: r.cover_url || undefined,
        tags: r.tags || undefined,
        createdAt: r.updated_at,
      },
    }));
    return NextResponse.json({ ok: true, data }, { headers: { 'Cache-Control': 'no-store' } });
  } catch (e: any) {
    return NextResponse.json({ ok: false, error: e?.message || 'failed' }, { status: 500 });
  }
}

