import { NextResponse } from 'next/server';
import { listBooks } from '@/app/db';

export const dynamic = 'force-dynamic';

export async function GET() {
  try {
    const rows = await listBooks();
    const data = rows.map((r) => ({
      id: r.id,
      bookId: r.book_id,
      title: r.title,
      wordCount: r.word_count,
      coverUrl: r.cover_url || undefined,
      tags: r.tags || undefined,
      createdAt: r.created_at,
    }));
    return NextResponse.json({ ok: true, data }, { headers: { 'Cache-Control': 'no-store' } });
  } catch (e: any) {
    return NextResponse.json({ ok: false, error: e?.message || 'failed' }, { status: 500 });
  }
}

