"use server";

import { auth } from '@/app/auth';
import { getUser, getOrInitUserBookProgress, updateUserBookProgress } from '@/app/db';

export async function advanceProgress(bookId: string, currentIdx: number, currentWordId?: number | null) {
  const session = await auth();
  if (!session?.user) throw new Error('UNAUTHORIZED');

  let userId: number | null = null;
  const maybeId = (session.user as any)?.id;
  const email = (session.user as any)?.email as string | undefined;
  if (maybeId !== undefined) {
    const n = Number(maybeId);
    if (!Number.isNaN(n)) userId = n;
  }
  if (!userId && email) {
    const rows = await getUser(email);
    if (rows && rows.length > 0) userId = Number(rows[0].id);
  }
  if (!userId) throw new Error('UNAUTHORIZED');

  // Ensure row exists
  await getOrInitUserBookProgress(userId, bookId);

  const idx = Math.max(0, currentIdx);
  const wordId = currentWordId ?? null;
  await updateUserBookProgress(userId, bookId, idx, wordId);

  return { ok: true } as const;
}

