/** @type {import('next').NextConfig} */
const nextConfig = {
  eslint: {
    ignoreDuringBuilds: true,
  },
  typescript: {
    ignoreBuildErrors: true,
  },
  images: {
    domains: [
      'iqfwopgjhbjczbvbgkiu.supabase.co', // 添加你的Supabase存储桶域名
      'localhost',
      'raw.githubusercontent.com',
      'd05faq8g91hkparudumg.baseapi.memfiredb.com', // 添加Supabase Memfire存储域名
    ],
    remotePatterns: [
      {
        protocol: 'https',
        hostname: '**.supabase.co',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: '**.supabase.in',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: '**.baseapi.memfiredb.com',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: 'placeholder.com',
        pathname: '/**',
      },
      {
        protocol: 'https',
        hostname: 'raw.githubusercontent.com',
        pathname: '/**',
      },
    ],
  },
}

export default nextConfig
