import { createClient } from './client'

/**
 * 上传工具Logo到Supabase存储
 * @param file 文件对象
 * @returns 上传的文件URL
 */
export async function uploadToolLogo(file: File): Promise<string> {
  const supabase = createClient()
  
  // 生成随机文件名，避免冲突
  const timestamp = Date.now()
  const fileExt = file.name.split('.').pop()
  const fileName = `${timestamp}.${fileExt}`
  
  const { data, error } = await supabase.storage
    .from('tool-logos')
    .upload(fileName, file, { upsert: true })
  
  if (error) {
    console.error('Error uploading logo:', error)
    throw error
  }
  
  // 获取文件的公共URL
  const { data: urlData } = supabase.storage
    .from('tool-logos')
    .getPublicUrl(fileName)
  
  return urlData.publicUrl
}

/**
 * 上传工具预览图到Supabase存储
 * @param file 文件对象
 * @returns 上传的文件URL
 */
export async function uploadToolPreview(file: File): Promise<string> {
  const supabase = createClient()
  
  // 生成随机文件名，避免冲突
  const timestamp = Date.now()
  const fileExt = file.name.split('.').pop()
  const fileName = `${timestamp}.${fileExt}`
  
  const { data, error } = await supabase.storage
    .from('tool-previews')
    .upload(fileName, file, { upsert: true })
  
  if (error) {
    console.error('Error uploading preview image:', error)
    throw error
  }
  
  // 获取文件的公共URL
  const { data: urlData } = supabase.storage
    .from('tool-previews')
    .getPublicUrl(fileName)
  
  return urlData.publicUrl
} 