export interface Category {
  id: string
  name: string
  icon: string
}

export async function getCategories(): Promise<Category[]> {
  try {
    const response = await fetch('/api/categories', {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json',
      },
    });

    if (!response.ok) {
      const error = await response.json();
      throw new Error(error.message || 'Failed to fetch categories');
    }

    const data = await response.json();
    return data;
  } catch (error) {
    console.error('Failed to fetch categories:', error);
    return [];
  }
} 