"use client"

import Link from "next/link"
import { Button } from "@/components/ui/button"

export default function VerifyEmailPage() {
  return (
    <div className="flex min-h-screen flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
      <div className="w-full max-w-md space-y-8 text-center">
        <div>
          <h1 className="text-2xl font-bold">验证您的邮箱</h1>
          <p className="mt-2 text-sm text-muted-foreground">
            我们已经向您的邮箱发送了一封验证邮件。请检查您的收件箱（以及垃圾邮件文件夹）并点击邮件中的链接完成注册。
          </p>
        </div>

        <div className="mt-8 space-y-4">
          <p className="text-sm text-muted-foreground">
            邮件可能需要几分钟才能到达。如果您没有收到邮件，可以检查垃圾邮件文件夹或者尝试重新注册。
          </p>

          <div className="pt-4">
            <Button asChild variant="outline">
              <Link href="/auth/login">返回登录</Link>
            </Button>
          </div>
        </div>
      </div>
    </div>
  )
} 