import Link from "next/link"
import type { Metadata } from "next"

export const metadata: Metadata = {
  title: "认证 - AI工具集",
  description: "登录、注册或管理您的AI工具集账户",
}

export default function AuthLayout({
  children,
}: Readonly<{
  children: React.ReactNode
}>) {
  return (
    <div className="min-h-screen flex flex-col">
      <main className="flex-1">
        {children}
      </main>
      
      <footer className="py-6 text-center text-sm text-muted-foreground">
        <div className="container mx-auto px-4">
          &copy; {new Date().getFullYear()} AI工具集. 保留所有权利.
        </div>
      </footer>
    </div>
  )
} 