"use client"

import Link from "next/link"
import { Button } from "@/components/ui/button"

export default function AuthErrorPage() {
  return (
    <div className="flex min-h-screen flex-col items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
      <div className="w-full max-w-md space-y-8 text-center">
        <div>
          <h1 className="text-2xl font-bold">认证错误</h1>
          <p className="mt-2 text-sm text-muted-foreground">
            我们在处理您的认证请求时遇到了问题。这可能是由于链接已过期或无效。
          </p>
        </div>

        <div className="mt-8 space-y-4">
          <div className="flex flex-col space-y-4">
            <Button asChild>
              <Link href="/auth/login">返回登录</Link>
            </Button>
            <Button asChild variant="outline">
              <Link href="/">返回首页</Link>
            </Button>
          </div>
        </div>
      </div>
    </div>
  )
} 