import { createAdminClient } from "@/utils/supabase/admin";
import { createClient } from "@/utils/supabase/server";

/**
 * 检查当前登录用户是否为管理员
 * @returns boolean 是否为管理员
 */
export async function isCurrentUserAdmin(): Promise<boolean> {
  try {
    // 获取当前登录用户
    const supabase = await createClient();
    const { data: { user }, error: userError } = await supabase.auth.getUser();
    
    if (userError || !user) {
      return false;
    }
    
    // 使用 admin client 绕过 RLS 查询 admin_users 表
    const adminClient = createAdminClient();
    const { data, error } = await adminClient
      .from('admin_users')
      .select('user_id')
      .eq('user_id', user.id)
      .single();
    
    if (error || !data) {
      return false;
    }
    
    return true;
  } catch (error) {
    console.error('检查管理员权限时出错:', error);
    return false;
  }
} 