# 数据库表结构

1. AI工具表：用于存放项目中的所有AI工具

```sql
create table
  public.ai_tools (
    id uuid not null default uuid_generate_v4 (),
    name character varying(200) not null,
    slug character varying(200) not null,
    description text not null,
    full_description text null,
    website_url character varying(255) null,
    image_url character varying(255) null,
    category_id uuid not null,
    created_at timestamp without time zone not null default now(),
    updated_at timestamp without time zone not null default now(),
    user_id uuid null,
    is_approved boolean not null default true,
    logo_url text null,
    type text null,
    constraint ai_tools_pkey primary key (id),
    constraint ai_tools_slug_key unique (slug),
    constraint ai_tools_category_id_fkey foreign key (category_id) references categories (id),
    constraint ai_tools_user_id_fkey foreign key (user_id) references users (id)
  ) tablespace pg_default;

create index if not exists idx_ai_tools_category_id on public.ai_tools using btree (category_id) tablespace pg_default;

create index if not exists idx_ai_tools_user_id on public.ai_tools using btree (user_id) tablespace pg_default;
```

2. AI工具分类表：用于存放项目中的所有AI工具分类

```sql
create table
  public.categories (
    id uuid not null default uuid_generate_v4 (),
    name character varying(100) not null,
    icon character varying(255) not null,
    created_at timestamp without time zone not null default now(),
    constraint categories_pkey primary key (id)
  ) tablespace pg_default;
```

3. 用户提交的AI工具记录表：用于存放用户提交的AI工具记录

```sql
create table
  public.tool_submissions (
    id uuid not null default uuid_generate_v4 (),
    name character varying(200) not null,
    description text not null,
    full_description text null,
    website_url character varying(255) not null,
    image_url character varying(255) null,
    category_id uuid not null,
    user_id uuid not null,
    status character varying(20) not null default 'pending'::character varying,
    admin_comments text null,
    created_at timestamp without time zone not null default now(),
    updated_at timestamp without time zone not null default now(),
    processed_at timestamp without time zone null,
    ai_tool_id uuid null,
    slug text not null,
    logo_url text null,
    constraint tool_submissions_pkey primary key (id),
    constraint tool_submissions_category_id_fkey foreign key (category_id) references categories (id),
    constraint tool_submissions_user_id_fkey foreign key (user_id) references users (id),
    constraint tool_submissions_ai_tool_id_fkey foreign key (ai_tool_id) references ai_tools (id)
  ) tablespace pg_default;

create index if not exists idx_tool_submissions_user_id on public.tool_submissions using btree (user_id) tablespace pg_default;

create index if not exists idx_tool_submissions_status on public.tool_submissions using btree (status) tablespace pg_default;

create index if not exists idx_tool_submissions_category_id on public.tool_submissions using btree (category_id) tablespace pg_default;

create index if not exists idx_tool_submissions_created_at on public.tool_submissions using btree (created_at) tablespace pg_default;

create index if not exists idx_tool_submissions_user_id on public.tool_submissions using btree (user_id) tablespace pg_default;

create index if not exists idx_tool_submissions_status on public.tool_submissions using btree (status) tablespace pg_default;

create index if not exists idx_tool_submissions_category_id on public.tool_submissions using btree (category_id) tablespace pg_default;

create index if not exists idx_tool_submissions_created_at on public.tool_submissions using btree (created_at) tablespace pg_default;
```

4. 管理员表：用于存放后台管理员信息

```sql
create table
  public.admin_users (
    user_id uuid not null,
    created_at timestamp without time zone null default now(),
    constraint admin_users_pkey primary key (user_id),
    constraint admin_users_user_id_fkey foreign key (user_id) references users (id) on delete cascade
  ) tablespace pg_default;
```