# AI 导航站后台需求文档

---

## 1. 项目概述

本后台系统用于管理 **AI 导航站** 的核心数据（AI 工具、分类、用户提交记录）并支撑运营人员进行内容审核及用户权限管理。

## 2. 目标与范围

* **目标**：

  1. 提供直观可视化的运营数据概览。
  2. 支持运营人员在后台快速添加 / 编辑 AI 工具。
  3. 支持审核用户提交的 AI 工具申请并一键入库。
  4. 支持为用户分配或撤销管理员权限，保障后台安全访问。

* **范围**：仅涵盖后台管理端（前端 Next.js + Supabase *Server Role* API），不包括导航站前台页面。

## 3. 角色与权限

| 角色       | 说明                      | 权限                         |
| -------- | ----------------------- | -------------------------- |
| **管理员**  | 通过 `admin_users` 表认定的用户 | 可访问后台全部功能模块；可设定其他用户是否为管理员。 |
| **普通用户** | 默认注册用户                  | 仅能通过前台发起工具提交；无法访问后台管理端。    |

## 4. 数据库表概览（已有）

* **ai\_tools** – 已上架工具主表。
* **categories** – 工具分类表。
* **tool\_submissions** – 用户提交记录表。

### 4.1 新增：`admin_users`

```sql
create table public.admin_users (
  user_id uuid primary key references auth.users(id) on delete cascade,
  created_at timestamp without time zone default now()
);
-- 启用 Row‑Level Security
alter table public.admin_users enable row level security;

-- 1) 仅允许已存在的管理员查看记录（判断当前 uid 是否已在表内）
create policy "Admins can read admin_users"
  on public.admin_users
  for select
  using (exists (select 1 from public.admin_users au where au.user_id = auth.uid()));

-- 2) 仅允许已存在的管理员添加新管理员
create policy "Admins can add admins"
  on public.admin_users
  for insert
  with check (exists (select 1 from public.admin_users au where au.user_id = auth.uid()));

-- 3) 仅允许已存在的管理员移除管理员
create policy "Admins can remove admins"
  on public.admin_users
  for delete
  using (exists (select 1 from public.admin_users au where au.user_id = auth.uid()));
```

> **约定**：判定管理员身份时，仅检查当前登录用户 `uid` 是否存在于 `admin_users` 表。

###

## 5. 功能模块

### 5.1 登录与权限校验

* 所有 `/api/admin/**` 路由及后台页面使用中间件校验 `auth.uid()` 是否存在于 `admin_users`。
* 无权限访问时重定向至前台首页或展示 403 页面。

### 5.2 概览（Sidebar #1）

| 功能                 | 说明                                                                                                                               |
| ------------------ | -------------------------------------------------------------------------------------------------------------------------------- |
| **顶部操作栏**          | 右上角「添加 AI 工具」按钮 -> 右侧 Drawer 表单；表单字段：名称、Slug、描述、分类、网站链接、Logo/图片等。                                                                |
| **统计卡片 ×4**        | 1) AI 工具总数（`ai_tools`）  2) 分类总数（`categories`）  3) 当日提交数（`tool_submissions` 当天）  4) 未审核提交数（`tool_submissions.status = 'pending'`） |
| **工具列表 DataTable** | 列字段：名称、分类、类型、创建时间、状态；支持搜索、分页、查看、编辑。                                                                                              |
| **查看/编辑 Drawer**   | 与新增表单复用；提交后更新 `ai_tools` 表并刷新列表。                                                                                                 |

### 5.3 审核（Sidebar #2）

| 功能        | 说明                                                                                                                                                                  |
| --------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **待审核列表** | 默认筛选 `tool_submissions.status = 'pending'`；字段：名称、用户、分类、提交时间。                                                                                                        |
| **审核操作**  | - **通过**：事务内执行 1) 插入 `ai_tools`（字段映射） 2) 将 `tool_submissions.status` 更新为 `'success'`, `ai_tool_id` 关联。  \|\n- **拒绝**：更新 `status = 'rejected'` 并填写 `admin_comments`。 |
| **批量操作**  | 复选框 + 批量通过 / 拒绝。                                                                                                                                                    |

### 5.4 用户管理（Sidebar #3）

| 功能       | 说明                                    |
| -------- | ------------------------------------- |
| **用户列表** | 来源 `auth.users`；列：Email、注册时间、是否管理员。   |
| **权限切换** | 开关按钮：写入 / 删除 `admin_users`。操作成功后即刻生效。 |

## 6. UI / 交互规范

* **框架**：Next.js 14, Tailwind CSS, shadcn/ui；暗色 & 亮色自适应。
* **布局**：固定侧边栏（宽 240px）+ 顶部导航栏（含用户头像下拉）。
* **Drawer**：宽度 480px，从右滑入；ESC 或点击遮罩关闭，保留未提交的表单状态。
* **DataTable**：基于 shadcn `DataTable` 组件，支持列排序、搜索、分页（50 / 页）。
* **表单校验**：前端使用 `zod` + React Hook Form；后端再次校验必填字段非空。

## 7. API 设计（仅展示核心）

| 方法   | 路径                                    | 功能           | 备注                         |         |            |
| ---- | ------------------------------------- | ------------ | -------------------------- | ------- | ---------- |
| GET  | `/api/admin/overview/stats`           | 获取四张统计卡的数据   |                            |         |            |
| GET  | `/api/admin/ai-tools`                 | 分页获取 AI 工具列表 | `?page=&pageSize=&search=` |         |            |
| POST | `/api/admin/ai-tools`                 | 新增 AI 工具     | body: 工具信息                 |         |            |
| PUT  | `/api/admin/ai-tools/{id}`            | 更新 AI 工具     |                            |         |            |
| GET  | `/api/admin/submissions`              | 获取提交列表       | \`?status=pending          | success | rejected\` |
| POST | `/api/admin/submissions/{id}/approve` | 审核通过 & 入库    |                            |         |            |
| POST | `/api/admin/submissions/{id}/reject`  | 审核拒绝         | body: `admin_comments`     |         |            |
| GET  | `/api/admin/users`                    | 获取用户列表       |                            |         |            |
| POST | `/api/admin/users/{id}/toggle-admin`  | 切换管理员状态      |                            |         |            |

> **注意**：所有 `/api/admin/**` 路由需在 Middleware 中验证 `admin_users`，请求上下文使用 Supabase **Service Role** Key 执行以绕过 RLS。
>
> ##
