import { isCurrentUserAdmin } from "@/utils/helpers/admin-check";
import { createClient } from "@/utils/supabase/server";
import { ArrowRight, LockIcon, UserPlusIcon } from "lucide-react";
import Link from "next/link";
import { redirect } from "next/navigation";

export default async function Home() {
  // 获取当前用户信息
  const supabase = await createClient();
  const { data: { user } } = await supabase.auth.getUser();
  
  // 如果用户已登录且是管理员，直接跳转到管理后台
  if (user) {
    const isAdmin = await isCurrentUserAdmin();
    if (isAdmin) {
      redirect("/admin");
    }
  }

  return (
    <div className="flex-1 flex flex-col items-center justify-center gap-12 px-4 py-16 text-center">
      <div className="max-w-2xl flex flex-col gap-8">
        <h1 className="text-4xl font-bold tracking-tight">AI 导航站后台管理系统</h1>
        <p className="text-lg text-muted-foreground">
          欢迎来到 AI 导航站管理后台，提供 AI 工具管理、内容审核及用户管理等功能。
        </p>
        
        <div className="flex flex-col gap-4 w-full max-w-md mx-auto">
          {user ? (
            // 已登录但不是管理员
            <div className="p-6 border rounded-lg bg-card text-card-foreground shadow-sm">
              <div className="flex flex-col items-center gap-4">
                <LockIcon className="w-12 h-12 text-destructive" />
                <h2 className="text-xl font-semibold">您没有管理员权限</h2>
                <p className="text-muted-foreground text-sm">
                  您当前登录的账户不是管理员账户，无法访问后台系统。请联系管理员获取权限。
                </p>
              </div>
            </div>
          ) : (
            // 未登录，显示登录/注册按钮
            <div className="flex flex-col gap-4">
              <Link 
                href="/sign-in"
                className="flex items-center justify-center gap-2 bg-primary text-primary-foreground px-6 py-3 rounded-md font-medium hover:bg-primary/90 transition-colors"
              >
                <span>管理员登录</span>
                <ArrowRight className="w-4 h-4" />
              </Link>
              
              <Link 
                href="/sign-up"
                className="flex items-center justify-center gap-2 bg-secondary text-secondary-foreground px-6 py-3 rounded-md font-medium hover:bg-secondary/90 transition-colors"
              >
                <UserPlusIcon className="w-4 h-4" />
                <span>注册新账户</span>
              </Link>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}
