import { createAdminClient } from "@/utils/supabase/admin";
import { NextResponse } from "next/server";

export async function GET() {
  try {
    const adminClient = createAdminClient();
    
    // 获取所有用户 - 从auth.users中获取用户信息
    const { data: users, error: usersError } = await adminClient
      .from('auth.users')
      .select('id, email, created_at');
    
    if (usersError) {
      console.error("获取用户列表失败:", usersError);
      
      // 尝试使用RPC函数获取用户列表
      // 使用supabase内置的auth模式
      const { data: authUsers, error: authError } = await adminClient.auth.admin.listUsers();
      
      if (authError) {
        console.error("通过Auth API获取用户列表失败:", authError);
        return NextResponse.json(
          { error: "获取用户列表失败" },
          { status: 500 }
        );
      }
      
      // 转换用户数据格式
      const formattedUsers = authUsers.users.map(user => ({
        id: user.id,
        email: user.email,
        created_at: user.created_at
      }));
      
      // 获取所有管理员
      const { data: admins, error: adminsError } = await adminClient
        .from('admin_users')
        .select('user_id');
      
      if (adminsError) {
        console.error("获取管理员列表失败:", adminsError);
        return NextResponse.json(
          { error: "获取管理员列表失败" },
          { status: 500 }
        );
      }
      
      // 将管理员信息合并到用户列表中
      const adminIds = admins.map(admin => admin.user_id);
      const usersWithAdminStatus = formattedUsers.map(user => ({
        ...user,
        isAdmin: adminIds.includes(user.id)
      }));
      
      return NextResponse.json({ users: usersWithAdminStatus });
    }
    
    // 获取所有管理员
    const { data: admins, error: adminsError } = await adminClient
      .from('admin_users')
      .select('user_id');
    
    if (adminsError) {
      console.error("获取管理员列表失败:", adminsError);
      return NextResponse.json(
        { error: "获取管理员列表失败" },
        { status: 500 }
      );
    }
    
    // 将管理员信息合并到用户列表中
    const adminIds = admins.map(admin => admin.user_id);
    const usersWithAdminStatus = users.map(user => ({
      ...user,
      isAdmin: adminIds.includes(user.id)
    }));
    
    return NextResponse.json({ users: usersWithAdminStatus });
  } catch (error) {
    console.error("获取用户列表时出错:", error);
    return NextResponse.json(
      { error: "服务器内部错误" },
      { status: 500 }
    );
  }
} 