import { NextRequest, NextResponse } from "next/server";
import { createAdminClient } from "@/utils/supabase/admin";
import { createClient } from "@/utils/supabase/server";

export async function GET(request: NextRequest) {
  try {
    // 验证管理员权限
    const adminClient = createAdminClient();
    const supabase = await createClient();
    
    const { data: { user } } = await supabase.auth.getUser();
    if (!user) {
      return NextResponse.json(
        { error: "未授权，请先登录" },
        { status: 401 }
      );
    }
    
    const { data: adminUser } = await adminClient
      .from("admin_users")
      .select("*")
      .eq("user_id", user.id)
      .single();
      
    if (!adminUser) {
      return NextResponse.json(
        { error: "您没有管理员权限" },
        { status: 403 }
      );
    }
    
    // 获取所有分类
    const { data: categories, error } = await adminClient
      .from("categories")
      .select("id, name")
      .order("name", { ascending: true });
      
    if (error) {
      console.error("获取分类列表错误:", error);
      return NextResponse.json(
        { error: "获取分类列表失败" },
        { status: 500 }
      );
    }
    
    return NextResponse.json({ categories });
    
  } catch (error) {
    console.error("处理分类列表请求错误:", error);
    return NextResponse.json(
      { error: "处理分类列表请求失败" },
      { status: 500 }
    );
  }
} 