import { createClient } from "@/utils/supabase/server";
import { LogOut } from "lucide-react";
import Link from "next/link";
import { signOutAction } from "../actions";
import { cn } from "@/lib/utils";
import AdminNavigation from "./admin-navigation";

export default async function AdminLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  // 获取用户信息
  const supabase = await createClient();
  const { data: { user } } = await supabase.auth.getUser();

  return (
    <div className="flex min-h-screen flex-col">
      {/* 管理后台顶部导航 */}
      <header className="bg-background border-b">
        <nav className="container flex h-16 items-center justify-between px-4">
          <div className="flex items-center gap-6">
            <Link href="/admin" className="text-xl font-bold">
              AI 导航站管理后台
            </Link>
            <div className="hidden md:flex items-center gap-6">
              <AdminNavigation />
            </div>
          </div>
          <div className="flex items-center gap-4">
            {user && (
              <div className="flex items-center gap-4">
                <span className="text-sm text-muted-foreground">
                  {user.email}
                </span>
                <form action={signOutAction}>
                  <button 
                    type="submit"
                    className="flex items-center gap-1 text-sm text-muted-foreground hover:text-foreground"
                  >
                    <LogOut className="h-4 w-4" />
                    <span>退出</span>
                  </button>
                </form>
              </div>
            )}
          </div>
        </nav>
      </header>

      {/* 主要内容区 */}
      <main className="flex-1 container px-4 py-6">
        {children}
      </main>
    </div>
  );
} 