"use client";

import React from "react";
import Link from "next/link";
import { usePathname } from "next/navigation";
import { Home, Box, ClipboardCheck, Users } from "lucide-react";
import { cn } from "@/lib/utils";

export default function AdminNavigation() {
  const pathname = usePathname();

  return (
    <nav className="flex items-center space-x-4 text-sm font-medium">
      <Link
        href="/admin"
        className={cn(
          "flex items-center gap-2 rounded-lg px-3 py-2 text-muted-foreground transition-all hover:text-foreground",
          pathname === "/admin" && "bg-accent text-accent-foreground"
        )}
      >
        <Home className="h-4 w-4" />
        <span>主页</span>
      </Link>
      <Link
        href="/admin/tools"
        className={cn(
          "flex items-center gap-2 rounded-lg px-3 py-2 text-muted-foreground transition-all hover:text-foreground",
          pathname.startsWith("/admin/tools") && "bg-accent text-accent-foreground"
        )}
      >
        <Box className="h-4 w-4" />
        <span>工具管理</span>
      </Link>
      <Link
        href="/admin/submissions"
        className={cn(
          "flex items-center gap-2 rounded-lg px-3 py-2 text-muted-foreground transition-all hover:text-foreground",
          pathname.startsWith("/admin/submissions") && "bg-accent text-accent-foreground"
        )}
      >
        <ClipboardCheck className="h-4 w-4" />
        <span>审核中心</span>
      </Link>
      <Link
        href="/admin/users"
        className={cn(
          "flex items-center gap-2 rounded-lg px-3 py-2 text-muted-foreground transition-all hover:text-foreground",
          pathname.startsWith("/admin/users") && "bg-accent text-accent-foreground"
        )}
      >
        <Users className="h-4 w-4" />
        <span>用户管理</span>
      </Link>
    </nav>
  );
} 