import { signInAction } from "@/app/actions";
import { FormMessage, Message } from "@/components/form-message";
import { SubmitButton } from "@/components/submit-button";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import Link from "next/link";

export default async function Login(props: { searchParams: Promise<Message> }) {
  const searchParams = await props.searchParams;
  return (
    <form className="flex flex-col space-y-4 bg-card p-6 rounded-lg shadow-sm">
      <div className="space-y-2 text-center">
        <h1 className="text-2xl font-bold">登录</h1>
        <p className="text-sm text-muted-foreground">
          还没有账号？{" "}
          <Link className="text-primary font-medium underline" href="/sign-up">
            立即注册
          </Link>
        </p>
      </div>

      <div className="space-y-4">
        <div className="space-y-2">
          <Label htmlFor="email">电子邮箱</Label>
          <Input name="email" placeholder="your@example.com" required />
        </div>
        
        <div className="space-y-2">
          <div className="flex justify-between items-center">
            <Label htmlFor="password">密码</Label>
            <Link
              className="text-xs text-primary hover:underline"
              href="/forgot-password"
            >
              忘记密码？
            </Link>
          </div>
          <Input
            type="password"
            name="password"
            placeholder="请输入密码"
            required
          />
        </div>

        <SubmitButton pendingText="登录中..." formAction={signInAction}>
          登录
        </SubmitButton>
        
        <FormMessage message={searchParams} />
      </div>
    </form>
  );
}
