# 语音记账 iOS 应用原型

## 项目简介

本项目是一款语音记账iOS应用的高保真原型设计，采用现代化的UI设计理念，严格遵循iOS Human Interface Guidelines。应用包含4个主要功能模块：记账、统计、历史和设置。

## 功能特性

### 🎤 语音记账
- **语音输入**：长按录音按钮进行语音记账
- **手动输入**：支持手动输入金额、标题、分类和时间
- **今日概览**：显示当日记账记录

### 📊 数据统计
- **多时间维度**：支持月/季度/年统计切换
- **趋势分析**：直观的折线图展示支出趋势
- **分类分布**：环形图显示各分类支出占比
- **详细分析**：分类支出明细和占比统计

### 📱 历史记录
- **按日分组**：清晰的日期分组显示
- **快速搜索**：支持关键词搜索历史记录
- **分类筛选**：按分类筛选记录
- **详细信息**：完整的记录详情展示

### ⚙️ 个性设置
- **货币管理**：支持人民币、美元、欧元切换
- **分类管理**：自定义支出分类的增删改查
- **数据管理**：CSV数据导出和数据清除功能
- **应用信息**：版本信息和相关条款

## 技术架构

### 前端技术栈
- **HTML5**：语义化结构
- **Tailwind CSS**：现代化样式框架
- **JavaScript**：交互逻辑实现
- **Chart.js**：数据可视化图表
- **FontAwesome**：图标组件库

### 设计规范
- **iOS HIG**：严格遵循苹果设计指南
- **响应式设计**：适配iPhone 15 Pro尺寸 (393x852px)
- **毛玻璃效果**：iOS风格的backdrop-filter效果
- **流畅动画**：CSS过渡动画增强用户体验

## 文件结构

```
/
├── index.html          # 主入口文件（展示所有页面）
├── home.html          # 记账主页面
├── statistics.html    # 统计页面
├── history.html       # 历史记录页面
├── settings.html      # 设置页面
└── README.md         # 项目说明文档
```

## 界面展示

### 🏠 记账页面 (home.html)
- **月支出概览**：显示本月总支出和同比变化
- **快捷操作**：语音输入和手动输入两种方式
- **今日记录**：实时显示当天的记账记录
- **交互设计**：点击手动输入弹出详细表单

### 📈 统计页面 (statistics.html)
- **时间切换器**：月/季度/年维度切换
- **数据卡片**：总支出和日均支出统计
- **趋势图表**：Chart.js实现的动态折线图
- **分布图表**：环形图展示分类占比
- **明细列表**：各分类详细数据展示

### 📜 历史页面 (history.html)
- **搜索功能**：快速搜索历史记录
- **日期分组**：按日期分组的粘性头部
- **记录详情**：完整的记录信息展示
- **滚动优化**：流畅的列表滚动体验

### ⚙️ 设置页面 (settings.html)
- **货币设置**：多货币支持的弹窗选择器
- **分类管理**：完整的CRUD操作界面
- **数据管理**：导出和清除功能
- **关于信息**：版本和法律信息

## 设计亮点

### 🎨 视觉设计
- **毛玻璃效果**：iOS原生风格的背景模糊
- **渐变配色**：现代化的渐变色彩搭配
- **圆角设计**：统一的圆角规范
- **阴影层次**：多层次的阴影营造深度感

### 🚀 交互体验
- **流畅动画**：CSS过渡动画提升交互感
- **视觉反馈**：hover状态和点击反馈
- **手势友好**：适合触屏操作的按钮尺寸
- **信息层级**：清晰的信息架构和视觉层级

### 📱 移动优化
- **iPhone适配**：专为iPhone 15 Pro优化
- **触控优化**：44px最小触控区域
- **滚动优化**：原生滚动体验
- **性能优化**：轻量级实现确保流畅运行

## 快速开始

1. **打开原型**：在浏览器中打开 `index.html`
2. **查看界面**：所有页面以iframe形式并排展示
3. **交互测试**：点击各个功能按钮体验交互效果
4. **移动预览**：使用浏览器开发者工具模拟移动设备

## 浏览器兼容性

- ✅ Chrome 90+
- ✅ Safari 14+
- ✅ Firefox 88+
- ✅ Edge 90+

## 开发说明

本原型专为展示和用户测试设计，包含完整的视觉设计和基础交互逻辑。所有图表数据为模拟数据，弹窗和交互功能均已实现。

### 核心特性
- 响应式布局适配移动设备
- 完整的用户界面组件
- 真实的交互反馈
- 现代化的视觉效果
- 可扩展的代码架构

本原型可直接用于：
- 产品演示和展示
- 用户体验测试
- 开发团队参考
- 投资方案展示

---

**语音记账应用** - 让记账变得更简单、更智能 🎯 