//
//  VoiceAccountApp.swift
//  VoiceAccount
//
//  Created by tanghui on 2025/6/12.
//

import SwiftUI
import SwiftData

@main
struct VoiceAccountApp: App {
    var sharedModelContainer: ModelContainer = {
        let schema = Schema([
            ExpenseRecord.self,
            ExpenseCategory.self,
        ])
        let modelConfiguration = ModelConfiguration(schema: schema, isStoredInMemoryOnly: false)

        do {
            return try ModelContainer(for: schema, configurations: [modelConfiguration])
        } catch {
            fatalError("Could not create ModelContainer: \(error)")
        }
    }()

    var body: some Scene {
        WindowGroup {
            ContentView()
        }
        .modelContainer(sharedModelContainer)
    }
}
