# 语音记账 iOS 应用

基于 SwiftUI 和 SwiftData 构建的现代化记账应用，严格还原了原型设计的界面和功能。

## 功能特性

### 📱 核心功能
- **TabView 导航**: 四个主要功能模块（记账、统计、历史、设置）
- **语音记账**: 支持语音输入记账记录
- **手动记账**: 详细的表单输入界面
- **数据统计**: 月度支出概览和统计分析
- **历史记录**: 按日期分组的历史记录查看
- **个性设置**: 分类管理、数据导出等功能

### 🎨 设计特色
- **iOS 风格**: 严格遵循 iOS Human Interface Guidelines
- **毛玻璃效果**: 使用 `.ultraThinMaterial` 实现原生模糊效果
- **渐变背景**: 温暖的渐变色彩搭配
- **现代布局**: 卡片式布局和圆角设计
- **流畅动画**: 自然的过渡动画效果

## 文件结构

```
VoiceAccount/
├── VoiceAccountApp.swift      # 应用入口
├── ContentView.swift          # 主要 TabView 容器
├── Models.swift               # 数据模型定义
├── SampleData.swift           # 示例数据
├── HomeView.swift            # 记账主页面
├── StatisticsView.swift      # 统计页面
├── HistoryView.swift         # 历史记录页面
├── SettingsView.swift        # 设置页面
├── ManualInputView.swift     # 手动输入页面
└── VoiceInputView.swift      # 语音输入页面
```

## 数据模型

### ExpenseRecord（费用记录）
- `id`: 唯一标识符
- `amount`: 金额
- `title`: 标题描述
- `category`: 关联的分类
- `timestamp`: 记录时间

### ExpenseCategory（支出分类）
- `id`: 唯一标识符
- `name`: 分类名称
- `iconName`: SF Symbol 图标名
- `colorHex`: 颜色十六进制值
- `recordCount`: 记录数量

## 技术栈

- **SwiftUI**: 现代化的UI框架
- **SwiftData**: 数据持久化
- **Combine**: 响应式编程
- **SF Symbols**: 系统图标库

## 界面展示

### 🏠 记账页面
- 月支出概览卡片
- 语音输入 / 手动输入按钮
- 今日记录列表
- 实时数据更新

### 📊 统计页面
- 时间周期选择器
- 支出统计卡片
- 趋势图表展示
- 分类分布分析

### 📜 历史页面
- 搜索和筛选功能
- 按日期分组显示
- 粘性日期头部
- 详细记录信息

### ⚙️ 设置页面
- 货币设置选择
- 分类管理功能
- 数据导出/清除
- 应用信息展示

## 运行说明

1. 使用 Xcode 15+ 打开项目
2. 选择 iOS 17+ 作为部署目标
3. 运行到模拟器或真机
4. 首次启动会自动创建默认分类和示例数据

## 特色功能

### 🎤 语音输入
- 模拟语音识别界面
- 录音状态指示
- 语音结果处理

### 📝 手动输入
- 直观的表单设计
- 分类网格选择
- 日期时间选择器
- 实时表单验证

### 📈 数据可视化
- 简化的图表展示
- 分类占比分析
- 趋势数据展示

### 🔧 个性化设置
- 多货币支持
- 自定义分类
- 数据管理功能

---

**语音记账应用** - 让记账变得更简单、更智能 🎯 