import Foundation
import SwiftData

@Model
final class ExpenseRecord {
    var id: UUID
    var amount: Double
    var title: String
    var category: ExpenseCategory
    var timestamp: Date
    
    init(amount: Double, title: String, category: ExpenseCategory, timestamp: Date = Date()) {
        self.id = UUID()
        self.amount = amount
        self.title = title
        self.category = category
        self.timestamp = timestamp
    }
}

@Model
final class ExpenseCategory {
    var id: UUID
    var name: String
    var iconName: String
    var colorHex: String
    var recordCount: Int
    
    init(name: String, iconName: String, colorHex: String) {
        self.id = UUID()
        self.name = name
        self.iconName = iconName
        self.colorHex = colorHex
        self.recordCount = 0
    }
}

// 默认分类数据
extension ExpenseCategory {
    static let defaultCategories: [ExpenseCategory] = [
        ExpenseCategory(name: "餐饮", iconName: "fork.knife", colorHex: "#3B82F6"),
        ExpenseCategory(name: "交通", iconName: "car", colorHex: "#10B981"),
        ExpenseCategory(name: "购物", iconName: "bag", colorHex: "#8B5CF6"),
        ExpenseCategory(name: "娱乐", iconName: "gamecontroller", colorHex: "#F59E0B"),
        ExpenseCategory(name: "医疗", iconName: "cross", colorHex: "#EF4444"),
        ExpenseCategory(name: "其他", iconName: "ellipsis", colorHex: "#6B7280")
    ]
} 