//
//  ContentView.swift
//  VoiceAccount
//
//  Created by tanghui on 2025/6/12.
//

import SwiftUI
import SwiftData

struct ContentView: View {
    @Environment(\.modelContext) private var modelContext
    @Query private var expenseRecords: [ExpenseRecord]
    @Query private var categories: [ExpenseCategory]
    
    var body: some View {
        TabView {
            HomeView()
                .tabItem {
                    Image(systemName: "house.fill")
                    Text("记账")
                }
            
            StatisticsView()
                .tabItem {
                    Image(systemName: "chart.bar.fill")
                    Text("统计")
                }
            
            HistoryView()
                .tabItem {
                    Image(systemName: "clock.fill")
                    Text("历史")
                }
            
            SettingsView()
                .tabItem {
                    Image(systemName: "gearshape.fill")
                    Text("设置")
                }
        }
        .accentColor(.blue)
        .onAppear {
            setupDefaultData()
        }
    }
    
    private func setupDefaultData() {
        // 如果没有分类数据，添加默认分类
        if categories.isEmpty {
            for defaultCategory in ExpenseCategory.defaultCategories {
                modelContext.insert(defaultCategory)
            }
            
            do {
                try modelContext.save()
            } catch {
                print("保存默认分类失败: \(error)")
            }
        }
    }
}

#Preview {
    ContentView()
        .modelContainer(for: [ExpenseRecord.self, ExpenseCategory.self], inMemory: true)
}
